---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.41
-- DDL creates recalc stats package
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: October 6, 2000 MSW
-- Date Updated: October 18, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 100600 Moved sp_INS_ReCalcStats to its own file, ddl_pkg_calc5.sql
-- MSW 100600 pkg_ALKINDI_RECALC_STAT created
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- MSW 100900 Renamed pkg_ALKINDI_RECALC_STAT to pkg_ALKINDI_STAT
-- MSW 100900 Added Column PRODUCT_CLUSTER_ID to USER_UC_STAT to enhance query performance
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_MEAN_DISTANCE to USER_UC_STAT
-- AHW 100900 Renamed all "STAT" columns that contained "TOTAL" to "TOT"
-- AHW 100900 Renamed all "STAT" columns that contained "W" to "WGT"
-- AHW 100900 Renamed all "STAT" table names that contained USER_CLUSTER to UC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT_CLUSTER to PC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT to PROD
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT to PROD (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT_CLUSTER to PC (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained USER_CLUSTER to UC (except foreign key references)
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_DISTANCE to USER_PROD_UC_STAT
-- AHW 101000 Removed "GROUP BY" parameter from many update statements
-- MSW 101000 Major STAT table structure changes.
-- AHW 101000 Renamed all "STAT" columns that contained FRACTION to FRN
-- RCK 101400 added pkg_ALKINDI_STAT.sp_INS_recalcProductScores
-- MSW 101500 Combined statements that insert initial records into prod_uc_stat and the statement that updated the product_cluster_id
-- MSW 101500 Split ReCalcStats up into smaller procedures
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- MSW 101800 Added pkg_ALKINDI_STAT.sp_UPD_USER_SUBGROUP
-- MSW 101800 Added pkg_ALKINDI_STAT.sp_INS_ReCalc_ALKINDEX_STAT
-- MSW 101800 Removed pkg_ALKINDI_STAT.sp_SEL_InsSubGroup;
-- MSW 101800 Removed pkg_ALKINDI_STAT.sp_UPD_BadRecsForLittleBI
-- MSW 101800 Removed pkg_ALKINDI_STAT.sp_INS_USER_INTO_SUBGROUP
-- MSW 101800 Changed pkg_ALKINDI_STAT.sp_INS_ReCalc_Prod_Stat to update PRODUCT_TYPE_ID column
-- MSW 101800 Changed pkg_ALKINDI_STAT.sp_INS_ReCalc_Prod_PC_Stat to update PRODUCT_TYPE_ID column
-- MSW 101800 Changed pkg_ALKINDI_STAT.sp_INS_ReCalc_Prod_UC_Stat to update PRODUCT_TYPE_ID column
-- MSW 102000 Changed pkg_ALKINDI_STAT.sp_INS_ReCalc_PROD_UC_STAT to UPDATE AVG_PROD_RATING_BY_UC column
---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_STAT
AS
  PROCEDURE sp_INS_ReCalc_Prod_Stat(
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_ReCalc_User_Stat(
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_ReCalc_PC_Stat(
	i_OMEGA				IN		NUMBER,
	i_DSCORE				IN		NUMBER,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_ReCalc_UC_Stat(
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_ReCalc_Prod_UC_Stat(
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_ReCalc_User_PC_Stat(
	i_OMEGA				IN		NUMBER,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_ReCalc_User_UC_Stat(
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_ReCalc_User_SF_Stat(
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_UPD_ReCalc_ProductScore(
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_ReCalc_PROD_PC_STAT(
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_ReCalc_USER_DATA_STAT(
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_UPD_USER_SUBGROUP;

  PROCEDURE sp_INS_ReCalc_ALKINDEX_STAT(
	i_DSCORE				IN		NUMBER,
	o_ERROR_CODE			OUT		NUMBER);

END pkg_ALKINDI_STAT;
/


-- ==========================================================================================

SHOW ERRORS

-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_STAT
AS

  PROCEDURE sp_INS_ReCalc_Prod_Stat(
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE PROD_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);	

	INSERT INTO PROD_STAT (PRODUCT_ID, PROD_WEIGHT)
	SELECT PRODUCT_ID, 1/COUNT(PRODUCT_ID)
	  FROM REL_CLUSTERABLE_PROD_CLUSTER
    GROUP BY PRODUCT_ID;

	UPDATE PROD_STAT S
	   SET PRODUCT_TYPE_ID = (SELECT PRODUCT_TYPE_ID
	  FROM PRODUCT P
	 WHERE S.PRODUCT_ID = P.PRODUCT_ID);

	UPDATE PROD_STAT S
	   SET (S.TOT_USER_SEEN, S.AVG_USER_EVAL) = (SELECT COUNT(E.EVALUATION_SCALE_ID), NVL(AVG(E.EVALUATION_SCALE_ID), 0)
	  FROM EVALUATION E
	 WHERE E.EVALUATION_SCALE_ID >= 1
	   AND E.PRODUCT_ID = S.PRODUCT_ID);

	UPDATE PROD_STAT S
	   SET (S.TOT_USER_EVAL) = (SELECT COUNT(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	 WHERE E.PRODUCT_ID = S.PRODUCT_ID);

	UPDATE PROD_STAT S1
	   SET (S1.FRN_USER_SEEN) = (SELECT DECODE(TOT_USER_SEEN, 0, 0, s2.TOT_USER_SEEN/s2.TOT_USER_EVAL)
	  FROM PROD_STAT S2
	 WHERE S1.PRODUCT_ID = S2.PRODUCT_ID);

-- MSW, Don't know how to determine new movies yet.  
-- MSW 101900, We'll set some products to be new so that we have data

	UPDATE PROD_STAT S
	   SET S.NEW_ADDITION_IND = 0
	 WHERE PRODUCT_ID < 15;

	UPDATE PROD_STAT S
	   SET S.NEW_ADDITION_IND = 1
	 WHERE PRODUCT_ID >= 15;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END sp_INS_ReCalc_Prod_Stat;

-- ==========================================================================================


  PROCEDURE sp_INS_ReCalc_User_Stat(
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE USER_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);	

	INSERT INTO USER_STAT (USER_ID)
	SELECT DISTINCT USER_ID
	  FROM REL_USER_CLUSTER;

	UPDATE USER_STAT S
	   SET (S.AVG_PROD_EVAL, S.TOT_PROD_SEEN) = (SELECT NVL(AVG(E.EVALUATION_SCALE_ID),0), COUNT(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	 WHERE E.EVALUATION_SCALE_ID >= 1
	   AND E.USER_ID = S.USER_ID
    GROUP BY E.USER_ID);

	UPDATE USER_STAT S
	   SET (S.TOT_PROD_EVAL) = (SELECT COUNT(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	 WHERE E.USER_ID = S.USER_ID
    GROUP BY E.USER_id);

	UPDATE USER_STAT S1
	   SET (S1.FRN_PROD_SEEN) = (SELECT DECODE(s2.TOT_PROD_EVAL, 0, 0, s2.TOT_PROD_SEEN/s2.TOT_PROD_EVAL)
	  FROM USER_STAT S2
	 WHERE S1.USER_ID = S2.USER_ID);


   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END sp_INS_ReCalc_User_Stat;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_PC_Stat(
	i_OMEGA				IN		NUMBER,
	i_DSCORE				IN		NUMBER,
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor_Truncate	NUMBER;
	v_Truncate_String	VARCHAR2(100);

	TYPE T_C IS REF CURSOR;
	v_CURSOR T_C;
	v_PCID NUMBER;
	v_GOOD NUMBER(8,3);
	v_BAD NUMBER(8,3);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR_Truncate	:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE PC_STAT';
	dbms_sql.parse(v_CURSOR_Truncate, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR_Truncate);	

	INSERT INTO PC_STAT (PRODUCT_CLUSTER_ID, TOT_PROD_IN_PC)
	SELECT DISTINCT PRODUCT_CLUSTER_ID, COUNT(PRODUCT_ID)
	  FROM REL_CLUSTERABLE_PROD_CLUSTER
    GROUP BY PRODUCT_CLUSTER_ID;

	UPDATE PC_STAT S
	   SET (S.WGT_TOT_PROD_IN_PC) = (SELECT SUM(P.PROD_WEIGHT)
	  FROM PROD_STAT P, REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE P.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

	UPDATE PC_STAT S
	   SET (S.TOT_NEW_PROD_IN_PC, S.WGT_TOT_NEW_PROD_IN_PC) = (SELECT COUNT(P.PRODUCT_ID), NVL(SUM(P.PROD_WEIGHT), 0)
	  FROM PROD_STAT P, REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE P.NEW_ADDITION_IND = 1
	   AND P.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

	UPDATE PC_STAT S
	   SET (S.TOT_OLD_PROD_IN_PC, S.WGT_TOT_OLD_PROD_IN_PC) = (SELECT COUNT(P.PRODUCT_ID), SUM(P.PROD_WEIGHT)
	  FROM PROD_STAT P, REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE P.NEW_ADDITION_IND = 0
	   AND P.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

	UPDATE PC_STAT S
	   SET (S.OME_WGT_TOT_OLD_PROD_IN_PC) = (SELECT SUM(P.PROD_WEIGHT)
	  FROM PROD_STAT P, REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE P.NEW_ADDITION_IND = 0
	   AND P.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
	   AND P.TOT_USER_SEEN < i_OMEGA);

	UPDATE PC_STAT S
	   SET (S.OME_TOT_OLD_FRN_USER_SEEN) = (SELECT NVL(SUM(P.FRN_USER_SEEN),0)
	  FROM PROD_STAT P, REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE P.NEW_ADDITION_IND = 0
	   AND P.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
	   AND P.TOT_USER_SEEN < i_OMEGA);

	UPDATE PC_STAT S
	   SET (TOT_CLUSTERABLE_PROD_IN_PC) = 
     (SELECT COUNT(PRODUCT_ID)
	  FROM REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);

	UPDATE PC_STAT S1
	   SET (S1.FRN_CLUSTERABLE_PROD_IN_PC) = (SELECT DECODE(s2.TOT_PROD_IN_PC, 0, 0, s2.TOT_CLUSTERABLE_PROD_IN_PC/s2.TOT_PROD_IN_PC)
	  FROM PC_STAT S2
	 WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID);

	OPEN v_CURSOR FOR
		SELECT PRODUCT_CLUSTER_ID
		  FROM PRODUCT_CLUSTER;
	LOOP
		FETCH v_CURSOR INTO v_PCID;
		EXIT WHEN v_CURSOR%NOTFOUND;

	SELECT SUM(DECODE(E.EVALUATION_SCALE_ID,3,1,4,1,5,1,6,1,0))
	     , SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,1,0))
	  INTO v_GOOD
	     , v_BAD
	  FROM EVALUATION E
	 WHERE E.EVALUATION_SCALE_ID >=1
	   AND E.PRODUCT_ID IN
     (SELECT PRODUCT_ID
	  FROM (SELECT PRODUCT_ID
        FROM PROD_UC_STAT
	 WHERE PRODUCT_CLUSTER_ID = v_PCID
  ORDER BY SCORE1 DESC
		 )
       WHERE ROWNUM < i_DSCORE);

--ORDERBYROWNUM

	UPDATE PC_STAT
	   SET FRN_BAD_REC = NVL((v_BAD / (v_GOOD + v_BAD)),0)
	 WHERE PRODUCT_CLUSTER_ID = v_PCID;

	END LOOP;
	CLOSE v_CURSOR;


   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END sp_INS_ReCalc_PC_Stat;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_UC_Stat(
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE UC_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);

	INSERT INTO UC_STAT (USER_CLUSTER_ID, USER_CLUSTER_INDEX, PRODUCT_CLUSTER_ID, TOT_USER_IN_UC)
	SELECT DISTINCT UC.USER_CLUSTER_ID, UC.USER_CLUSTER_INDEX, UC.PRODUCT_CLUSTER_ID, COUNT(R.USER_ID)
	  FROM REL_USER_CLUSTER R, USER_CLUSTER UC
	 WHERE R.USER_CLUSTER_ID(+) = UC.USER_CLUSTER_ID
    GROUP BY UC.USER_CLUSTER_ID, UC.USER_CLUSTER_INDEX, UC.PRODUCT_CLUSTER_ID;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END sp_INS_ReCalc_UC_Stat;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_USER_PC_Stat(
	i_OMEGA				IN		NUMBER,
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE USER_PC_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);	

--	INSERT INTO USER_PC_STAT (USER_ID, PRODUCT_CLUSTER_ID)
--	SELECT DISTINCT USER_ID, PRODUCT_CLUSTER_ID
--	  FROM EVALUATION, REL_CLUSTERABLE_PROD_CLUSTER
--	 WHERE EVALUATION.PRODUCT_ID = REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_ID(+);

	INSERT INTO USER_PC_STAT (USER_ID, PRODUCT_CLUSTER_ID)
	SELECT USER_ID, PRODUCT_CLUSTER_ID
	  FROM REL_USER_CLUSTER;

	UPDATE USER_PC_STAT S
	   SET (S.TOT_PROD_EVAL) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0)
	  FROM EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID(+)
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);

	UPDATE USER_PC_STAT S
	   SET (S.FRN_OF_PC_EVAL) = (SELECT DECODE(PC.TOT_PROD_IN_PC, 0, 0, S.TOT_PROD_EVAL/PC.TOT_PROD_IN_PC)
	  FROM PC_STAT PC
	 WHERE S.PRODUCT_CLUSTER_ID = PC.PRODUCT_CLUSTER_ID);

	UPDATE USER_PC_STAT S
	   SET (S.TOT_PROD_SEEN, S.AVG_PROD_EVAL) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0), NVL(AVG(E.EVALUATION_SCALE_ID), 0)
	  FROM EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID(+)
	   AND E.EVALUATION_SCALE_ID >= 1
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);

	UPDATE USER_PC_STAT S1
	   SET (S1.FRN_OF_EVAL_SEEN) = (SELECT DECODE(S2.TOT_PROD_EVAL, 0, 0, S2.TOT_PROD_SEEN/S2.TOT_PROD_EVAL)
	  FROM USER_PC_STAT S2
	 WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
	   AND S1.USER_ID = S2.USER_ID);

	UPDATE USER_PC_STAT S
	   SET (S.TOT_NEW_PROD_EVAL) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0)
	  FROM EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	     , PROD_STAT P
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
	   AND P.NEW_ADDITION_IND = 1);

	UPDATE USER_PC_STAT S
	   SET (S.TOT_NEW_PROD_SEEN, AVG_NEW_PROD_EVAL) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0), NVL(AVG(E.EVALUATION_SCALE_ID), 0)
	  FROM EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	     , PROD_STAT P
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID
	   AND E.EVALUATION_SCALE_ID >= 1
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
	   AND P.NEW_ADDITION_IND = 1);

	UPDATE USER_PC_STAT S1
	   SET (S1.FRN_OF_NEW_EVAL_SEEN) = (SELECT DECODE(S2.TOT_NEW_PROD_EVAL, 0, 0, S2.TOT_NEW_PROD_SEEN/S2.TOT_NEW_PROD_EVAL)
	  FROM USER_PC_STAT S2
	 WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
	   AND S1.USER_ID = S2.USER_ID);

	UPDATE USER_PC_STAT S
	   SET (S.TOT_OLD_PROD_EVAL) = (SELECT NVL(count(E.EVALUATION_SCALE_ID),0)
	  FROM EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	     , PROD_STAT P
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID
	   AND E.PRODUCT_ID = P.PRODUCT_ID
	   AND P.NEW_ADDITION_IND = 0
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);

	UPDATE USER_PC_STAT S
	   SET (S.TOT_OLD_PROD_SEEN, AVG_OLD_PROD_EVAL) = (SELECT count(E.EVALUATION_SCALE_ID), NVL(AVG(E.EVALUATION_SCALE_ID), 0)
	  FROM EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	     , PROD_STAT P
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID
	   AND E.EVALUATION_SCALE_ID >= 1
	   AND E.PRODUCT_ID = P.PRODUCT_ID
	   AND P.NEW_ADDITION_IND = 0
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID);

	UPDATE USER_PC_STAT S1
	   SET (S1.FRN_OF_OLD_EVAL_SEEN) = (SELECT DECODE(S2.TOT_OLD_PROD_EVAL, 0, 0, S2.TOT_OLD_PROD_SEEN/S2.TOT_OLD_PROD_EVAL)
	  FROM USER_PC_STAT S2
	 WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
	   AND S1.USER_ID = S2.USER_ID);

	UPDATE USER_PC_STAT S
	   SET (S.OME_TOT_OLD_PROD_EVAL) = (SELECT count(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	     , PROD_STAT P
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID
	   AND E.PRODUCT_ID = P.PRODUCT_ID
	   AND P.NEW_ADDITION_IND = 0
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
	   AND P.TOT_USER_SEEN < i_OMEGA);

	UPDATE USER_PC_STAT S
	   SET (S.OME_TOT_OLD_PROD_SEEN) = (SELECT count(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	     , PROD_STAT P
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID
	   AND E.EVALUATION_SCALE_ID >= 1
	   AND E.PRODUCT_ID = P.PRODUCT_ID
	   AND P.NEW_ADDITION_IND = 0
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
	   AND P.TOT_USER_SEEN < i_OMEGA);

	UPDATE USER_PC_STAT S1
	   SET (S1.OME_FRN_OF_OLD_EVAL_SEEN) = (SELECT DECODE(S2.OME_TOT_OLD_PROD_EVAL, 0, 0, S2.OME_TOT_OLD_PROD_SEEN/S2.OME_TOT_OLD_PROD_EVAL)
	  FROM USER_PC_STAT S2
	 WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
	   AND S1.USER_ID = S2.USER_ID);

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END SP_INS_RECALC_USER_PC_STAT;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_PROD_UC_Stat(
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE PROD_UC_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);


	INSERT INTO PROD_UC_STAT (PRODUCT_ID, PRODUCT_INDEX, USER_CLUSTER_ID, USER_CLUSTER_INDEX, PRODUCT_CLUSTER_ID)
	SELECT DISTINCT R.PRODUCT_ID, R.PRODUCT_INDEX, UC.USER_CLUSTER_ID, UC.USER_CLUSTER_INDEX, UC.PRODUCT_CLUSTER_ID
	  FROM REL_CLUSTERABLE_PROD_CLUSTER R, USER_CLUSTER UC
	 WHERE R.PRODUCT_CLUSTER_ID = UC.PRODUCT_CLUSTER_ID;

	UPDATE PROD_UC_STAT S
	   SET PRODUCT_TYPE_ID = (SELECT PRODUCT_TYPE_ID
	  FROM PRODUCT P
	 WHERE S.PRODUCT_ID = P.PRODUCT_ID);

	UPDATE PROD_UC_STAT S
	   SET (S.TOT_USER_EVAL) = (SELECT COUNT(E.PRODUCT_ID)
	  FROM EVALUATION E, REL_USER_CLUSTER R
	 WHERE E.USER_ID = R.USER_ID
	   AND S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
	   AND S.PRODUCT_ID = E.PRODUCT_ID);

	UPDATE PROD_UC_STAT S
	   SET (S.TOT_USER_SEEN, S.AVG_PROD_EVAL_BY_UC, S.SIGMA_SQUARED) = (SELECT COUNT(E.PRODUCT_ID), NVL(AVG(E.EVALUATION_SCALE_ID),0), SUM(POWER(E.EVALUATION_SCALE_ID, 2))/COUNT(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E, REL_USER_CLUSTER R
	 WHERE E.USER_ID = R.USER_ID
	   AND S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
	   AND S.PRODUCT_ID = E.PRODUCT_ID
	   AND E.EVALUATION_SCALE_ID >= 1);

	UPDATE PROD_UC_STAT S
	   SET (S.FRN_OF_UC_EVAL, S.FRN_OF_UC_SEEN) = (SELECT DECODE(UC.TOT_USER_IN_UC, 0, 0, S.TOT_USER_EVAL/UC.TOT_USER_IN_UC), DECODE(UC.TOT_USER_IN_UC, 0, 0, S.TOT_USER_SEEN/UC.TOT_USER_IN_UC)
	  FROM UC_STAT UC
	 WHERE S.USER_CLUSTER_ID = UC.USER_CLUSTER_ID);

	UPDATE PROD_UC_STAT S
	   SET (V) = (SELECT POWER(PS.AVG_USER_EVAL-S.AVG_PROD_EVAL_BY_UC,2)
	  FROM PROD_STAT PS
	 WHERE S.PRODUCT_ID = PS.PRODUCT_ID);

	UPDATE PROD_UC_STAT S1
	   SET (S1.AVG_V_BY_PC) = (SELECT AVG(V)
	  FROM PROD_UC_STAT S2
	 WHERE S1.PRODUCT_ID = S2.PRODUCT_ID
	   AND S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
    GROUP BY S1.PRODUCT_ID, PRODUCT_CLUSTER_ID);

-- MSW 102000
	UPDATE PROD_UC_STAT S
	   SET (S.AVG_PROD_RATING_BY_UC) = (SELECT NVL(SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,2,3,3,4,4,5,5,6,6,0))/COUNT(E.EVALUATION_SCALE_ID),0)
	  FROM EVALUATION E, REL_USER_CLUSTER R
	 WHERE E.USER_ID = R.USER_ID
	   AND S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
	   AND S.PRODUCT_ID = E.PRODUCT_ID);





   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END sp_INS_ReCalc_PROD_UC_Stat;


-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_USER_UC_Stat(
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE USER_UC_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);

	INSERT INTO USER_UC_STAT (USER_ID, USER_CLUSTER_ID, PRODUCT_CLUSTER_ID)
	SELECT R.USER_ID, UC.USER_CLUSTER_ID, UC.PRODUCT_CLUSTER_ID
	  FROM REL_USER_CLUSTER R, USER_CLUSTER UC
	 WHERE R.USER_CLUSTER_ID = UC.USER_CLUSTER_ID(+);

	UPDATE USER_UC_STAT S
	   SET (S.CALC_M2) = (SELECT NVL(SUM(POWER(E.EVALUATION_SCALE_ID - PUCS.AVG_PROD_EVAL_BY_UC, 2))/SUM(PUCS.SIGMA_SQUARED),0)
	  FROM EVALUATION E, PROD_UC_STAT PUCS
	 WHERE PUCS.PRODUCT_ID = E.PRODUCT_ID
	   AND E.EVALUATION_SCALE_ID >= 1
	   AND E.USER_ID = S.USER_ID
	   AND PUCS.USER_CLUSTER_ID = S.USER_CLUSTER_ID);

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END sp_INS_ReCalc_USER_UC_Stat;


-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_USER_SF_Stat(
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE USER_SF_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);

	INSERT INTO USER_SF_STAT (USER_ID, SCORING_FUNCTION_ID, TOT_REC)
	SELECT USER_ID, SCORING_FUNCTION_ID, COUNT(SCORING_FUNCTION_ID)
	  FROM RECOMMENDATION
    GROUP BY USER_ID, SCORING_FUNCTION_ID;

	UPDATE USER_SF_STAT S
	   SET (S.TOT_INT) = (SELECT COUNT(EVALUATION_SCALE_ID)
	  FROM EVALUATION E, RECOMMENDATION R
	 WHERE E.USER_ID(+) = R.USER_ID
	   AND E.PRODUCT_ID(+) = R.PRODUCT_ID
	   AND E.EVALUATION_SCALE_ID = -2);

	UPDATE USER_SF_STAT S
	   SET (S.TOT_NOT_INT) = (SELECT COUNT(EVALUATION_SCALE_ID)
	  FROM EVALUATION E, RECOMMENDATION R
	 WHERE E.USER_ID(+) = R.USER_ID
	   AND E.PRODUCT_ID(+) = R.PRODUCT_ID
	   AND E.EVALUATION_SCALE_ID = -3);

	UPDATE USER_SF_STAT S
	   SET (S.TOT_NOT_KNO) = (SELECT COUNT(EVALUATION_SCALE_ID)
	  FROM EVALUATION E, RECOMMENDATION R
	 WHERE E.USER_ID(+) = R.USER_ID
	   AND E.PRODUCT_ID(+) = R.PRODUCT_ID
	   AND E.EVALUATION_SCALE_ID = -4);

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;
 END sp_INS_ReCalc_USER_SF_Stat;


-- ==========================================================================================


  PROCEDURE sp_UPD_ReCalc_ProductScore(
	o_ERROR_CODE			OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	UPDATE PROD_UC_STAT S
	 SET SCORE1 = 
	 (SELECT NVL(MIN(
	   (count(EVALUATION_SCALE_ID) + 
	    sum(decode(EVALUATION_SCALE_ID,2,1,3,1,4,1,5,1,6,1,0)) +
	    sum(decode(EVALUATION_SCALE_ID,3,1,4,1,5,1,6,1,0)) +
	    sum(decode(EVALUATION_SCALE_ID,4,1,5,1,6,1,0)) +
	    sum(decode(EVALUATION_SCALE_ID,5,1,6,1,0)) +
	    sum(decode(EVALUATION_SCALE_ID,6,1,0))
	   ) / count(EVALUATION_SCALE_ID)),0)
	FROM EVALUATION E, REL_USER_CLUSTER R, REL_CLUSTERABLE_PROD_CLUSTER RC
	WHERE E.EVALUATION_SCALE_ID >=1
	 and E.USER_ID = R.USER_ID
	 and E.PRODUCT_ID (+) = RC.PRODUCT_ID
	 and R.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
	 and S.PRODUCT_ID = E.PRODUCT_ID
	GROUP BY RC.PRODUCT_CLUSTER_ID,
	 R.USER_CLUSTER_ID,
	 E.PRODUCT_ID);	

	UPDATE PROD_UC_STAT S
	 SET SCORE2 = 
	 (SELECT NVL(MIN(
	   COUNT(*)),0)
	FROM EVALUATION E, REL_USER_CLUSTER R, REL_CLUSTERABLE_PROD_CLUSTER RC
	WHERE E.EVALUATION_SCALE_ID >=5
	 and E.USER_ID = R.USER_ID
	 and E.PRODUCT_ID (+) = RC.PRODUCT_ID
	 and R.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
	 and S.PRODUCT_ID = E.PRODUCT_ID
	GROUP BY RC.PRODUCT_CLUSTER_ID,
	 R.USER_CLUSTER_ID,
	 E.PRODUCT_ID);	

	UPDATE PROD_UC_STAT S
	 SET SCORE3 = 
	 (SELECT NVL(MIN(
	   -1*count(*) + 
	    sum(decode(EVALUATION_SCALE_ID,4,1,5,1,6,1,0)) +
	    sum(decode(EVALUATION_SCALE_ID,5,1,6,1,0))),0)
	FROM EVALUATION E, REL_USER_CLUSTER R, REL_CLUSTERABLE_PROD_CLUSTER RC
	WHERE E.EVALUATION_SCALE_ID >=1
	 and E.USER_ID = R.USER_ID
	 and E.PRODUCT_ID (+) = RC.PRODUCT_ID
	 and R.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
	 and S.PRODUCT_ID = E.PRODUCT_ID
	GROUP BY RC.PRODUCT_CLUSTER_ID,
	 R.USER_CLUSTER_ID,
	 E.PRODUCT_ID);	

	UPDATE PROD_UC_STAT S
	 SET SCORE4 = 
	 (SELECT NVL(MIN(
	   COUNT(*)),0)
	FROM EVALUATION E, REL_USER_CLUSTER R, REL_CLUSTERABLE_PROD_CLUSTER RC
	WHERE E.EVALUATION_SCALE_ID >=1
	 and E.USER_ID = R.USER_ID
	 and E.PRODUCT_ID (+) = RC.PRODUCT_ID
	 and R.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
	 and S.PRODUCT_ID = E.PRODUCT_ID
	GROUP BY RC.PRODUCT_CLUSTER_ID,
	 R.USER_CLUSTER_ID,
	 E.PRODUCT_ID);	

	UPDATE PROD_UC_STAT S
	 SET SCORE5 = 
	 (SELECT NVL(MIN( 
	   (-3*count(*) + 
	    sum(decode(EVALUATION_SCALE_ID,6,1,0))
	   )),0)
	FROM EVALUATION E, REL_USER_CLUSTER R, REL_CLUSTERABLE_PROD_CLUSTER RC
	WHERE E.EVALUATION_SCALE_ID >=1
	 and E.USER_ID = R.USER_ID
	 and E.PRODUCT_ID (+) = RC.PRODUCT_ID
	 and R.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
	 and S.PRODUCT_ID = E.PRODUCT_ID
	GROUP BY RC.PRODUCT_CLUSTER_ID,
	 R.USER_CLUSTER_ID,
	 E.PRODUCT_ID);	

	UPDATE PROD_UC_STAT S
	 SET SCORE6 = 
	 (SELECT NVL(MIN(
	   (sum(decode(EVALUATION_SCALE_ID,5,1,6,1,0))
	   ) / count(*)),0)
	FROM EVALUATION E, REL_USER_CLUSTER R, REL_CLUSTERABLE_PROD_CLUSTER RC
	WHERE E.EVALUATION_SCALE_ID >=1
	 and E.USER_ID = R.USER_ID
	 and E.PRODUCT_ID (+) = RC.PRODUCT_ID
	 and R.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.PRODUCT_CLUSTER_ID = RC.PRODUCT_CLUSTER_ID
	 and S.USER_CLUSTER_ID = R.USER_CLUSTER_ID
	 and S.PRODUCT_ID = E.PRODUCT_ID
	GROUP BY RC.PRODUCT_CLUSTER_ID,
	 R.USER_CLUSTER_ID,
	 E.PRODUCT_ID);	


	UPDATE PROD_UC_STAT S
	 SET SCORE7 = 0;


	UPDATE PROD_UC_STAT S
	 SET SCORE8 = 0;


   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END sp_UPD_ReCalc_ProductScore;

-- ==========================================================================================


  PROCEDURE sp_INS_ReCalc_USER_DATA_STAT(
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE USER_DATA_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);	

	INSERT INTO USER_DATA_STAT (USER_ID, PRODUCT_CLUSTER_ID)
	SELECT DISTINCT R.USER_ID, R.PRODUCT_CLUSTER_ID
	  FROM REL_USER_CLUSTER R;

	UPDATE USER_DATA_STAT S
	   SET (NI, NEW_PROD_NI, NEW_PROD_MI, OLD_PROD_OME_NI, OLD_PROD_OME_MI) = (SELECT NVL(MIN(WGT_TOT_PROD_IN_PC),0), NVL(MIN(WGT_TOT_NEW_PROD_IN_PC),0), NVL(MIN(TOT_NEW_PROD_IN_PC),0), NVL(MIN(OME_WGT_TOT_OLD_PROD_IN_PC),0), NVL(MIN(TOT_OLD_PROD_IN_PC),0)
	  FROM PC_STAT PCS
	 WHERE S.PRODUCT_CLUSTER_ID = PCS.PRODUCT_CLUSTER_ID);

	UPDATE USER_DATA_STAT S
	   SET (RI, EI, FI, NEW_PROD_EI, OLD_PROD_OME_EI) = (SELECT NVL(MIN(AVG_PROD_EVAL),0), NVL(MIN(FRN_OF_EVAL_SEEN),0), NVL(MIN(FRN_OF_PC_EVAL),0), NVL(MIN(FRN_OF_NEW_EVAL_SEEN),0), NVL(MIN(FRN_OF_OLD_EVAL_SEEN),0)
	  FROM USER_PC_STAT UPCS
	 WHERE S.PRODUCT_CLUSTER_ID = UPCS.PRODUCT_CLUSTER_ID
	   AND S.USER_ID = UPCS.USER_ID);

	UPDATE USER_DATA_STAT S
	   SET (EAVE, RAVE) = (SELECT NVL(MIN(AVG_PROD_EVAL),0), NVL(MIN(FRN_PROD_SEEN),0)
	  FROM USER_STAT US
	 WHERE S.USER_ID = US.USER_ID);

	UPDATE USER_DATA_STAT S
	   SET (NEW_PROD_EPI) = (SELECT NVL(SUM(FRN_USER_SEEN),0)
	  FROM PROD_STAT PS, REL_PRODUCT_CLUSTER R
 	 WHERE PS.PRODUCT_ID = R.PRODUCT_ID
	   AND PS.NEW_ADDITION_IND = 1
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

	UPDATE USER_DATA_STAT S
	   SET (OLD_PROD_OME_EPI) = (SELECT NVL(SUM(FRN_USER_SEEN),0)
	  FROM PROD_STAT PS, REL_PRODUCT_CLUSTER R
 	 WHERE PS.PRODUCT_ID = R.PRODUCT_ID
	   AND PS.NEW_ADDITION_IND = 0
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END sp_INS_ReCalc_USER_DATA_STAT;

-- ==========================================================================================

  PROCEDURE sp_INS_ReCalc_PROD_PC_STAT(
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);
   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE PROD_PC_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);	


	INSERT INTO PROD_PC_STAT (PRODUCT_ID, PRODUCT_CLUSTER_ID)
	SELECT R.PRODUCT_ID, R.PRODUCT_CLUSTER_ID
	  FROM REL_CLUSTERABLE_PROD_CLUSTER R;

	UPDATE PROD_PC_STAT S
	   SET PRODUCT_TYPE_ID = (SELECT PRODUCT_TYPE_ID
	  FROM PRODUCT P
	 WHERE S.PRODUCT_ID = P.PRODUCT_ID);

	UPDATE PROD_PC_STAT S
	   SET (S.TOT_USER_SEEN, S.AVG_USER_EVAL) = (SELECT COUNT(E.EVALUATION_SCALE_ID), NVL(AVG(E.EVALUATION_SCALE_ID), 0)
	  FROM EVALUATION E, REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE E.EVALUATION_SCALE_ID >= 1
	   AND E.PRODUCT_ID = S.PRODUCT_ID
	   AND E.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

	UPDATE PROD_PC_STAT S
	   SET (S.TOT_USER_EVAL) = (SELECT COUNT(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E, REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE E.PRODUCT_ID = S.PRODUCT_ID
	   AND E.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID);

	UPDATE PROD_PC_STAT S1
	   SET (S1.FRN_USER_SEEN) = (SELECT DECODE(TOT_USER_SEEN, 0, 0, s2.TOT_USER_SEEN/s2.TOT_USER_EVAL)
	  FROM PROD_PC_STAT S2
	 WHERE S1.PRODUCT_ID = S2.PRODUCT_ID
	   AND S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID);

	UPDATE PROD_PC_STAT S
	   SET (S.NEW_ADDITION_IND) = (SELECT PS.NEW_ADDITION_IND
	  FROM PROD_STAT PS
	 WHERE PS.PRODUCT_ID = S.PRODUCT_ID);

	UPDATE PROD_PC_STAT S
	   SET (S.AVG_V) = (SELECT AVG(PUCS.V)
	  FROM PROD_UC_STAT PUCS
	 WHERE S.PRODUCT_ID = PUCS.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = PUCS.PRODUCT_CLUSTER_ID
    GROUP BY S.PRODUCT_ID, S.PRODUCT_CLUSTER_ID);

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

  END sp_INS_ReCalc_PROD_PC_STAT;

-- ==========================================================================================


  PROCEDURE sp_UPD_USER_SUBGROUP IS

--This gets all the PC, US and counts of users in UC
	CURSOR c_cursor IS
	SELECT PRODUCT_CLUSTER_ID
     	     , USER_CLUSTER_ID
	     , COUNT(USER_ID) AS v_COUNT_USER
	  FROM REL_USER_CLUSTER
    GROUP BY PRODUCT_CLUSTER_ID
	     , USER_CLUSTER_ID;

	TYPE T_C IS REF CURSOR;
	v_RANK T_C;
	
	v_cursor 	 c_cursor%ROWTYPE;
	v_PC_ID 	 NUMBER;
	v_UC_ID 	 NUMBER;
	v_COUNT_USER NUMBER;
	v_USER_ID 	 NUMBER;
	v_LOOP1	 NUMBER;
	v_INDEX	 NUMBER;
	v_NUM_OF_SUB NUMBER;
	BEGIN


	OPEN c_cursor;

FETCH c_cursor into v_cursor;

V_PC_ID	:= v_cursor.PRODUCT_CLUSTER_ID;
v_UC_ID	:= v_cursor.USER_CLUSTER_ID;
v_COUNT_USER := v_cursor.v_COUNT_USER;

WHILE c_cursor%FOUND LOOP

IF v_COUNT_USER <= 6 THEN
	v_NUM_OF_SUB := 1;
ELSIF v_COUNT_USER <= 12 THEN
	v_NUM_OF_SUB := 2;
ELSE
	v_NUM_OF_SUB := 4;
END IF;

	OPEN v_RANK FOR
SELECT RUC.USER_ID
  FROM EVALUATION E, REL_USER_CLUSTER RUC, REL_CLUSTERABLE_PROD_CLUSTER RPC
WHERE E.USER_ID = RUC.USER_ID
  AND E.PRODUCT_ID = RPC.PRODUCT_ID
  AND RUC.USER_CLUSTER_ID = v_UC_ID
  AND RPC.PRODUCT_CLUSTER_ID = v_PC_ID
GROUP BY RUC.USER_ID
ORDER BY COUNT(E.PRODUCT_ID) ASC;

FETCH v_RANK INTO v_USER_ID;
v_LOOP1 := 1;
v_INDEX := 0;

WHILE v_RANK%FOUND LOOP

IF (v_COUNT_USER/v_NUM_OF_SUB) >=  v_LOOP1 THEN
	v_INDEX := 0;
ELSIF (2*(v_COUNT_USER/v_NUM_OF_SUB)) >= v_LOOP1 THEN
	v_INDEX := 1;
ELSIF (3*(v_COUNT_USER/v_NUM_OF_SUB)) >= v_LOOP1 THEN
	v_INDEX := 2;
ELSE
	v_INDEX := 3;
END IF;

UPDATE REL_USER_CLUSTER
   SET USER_CLUSTER_SUBGROUP_INDEX = v_INDEX
 WHERE USER_ID = v_USER_ID
   AND USER_CLUSTER_ID = v_UC_ID;

v_LOOP1 := v_LOOP1 + 1;
FETCH v_RANK INTO v_USER_ID;

END LOOP;

FETCH c_cursor into v_cursor;

V_PC_ID	:= v_cursor.PRODUCT_CLUSTER_ID;
v_UC_ID	:= v_cursor.USER_CLUSTER_ID;
v_COUNT_USER := v_cursor.v_COUNT_USER;

END LOOP;

CLOSE c_cursor;

 END sp_UPD_USER_SUBGROUP;






  PROCEDURE sp_INS_ReCalc_ALKINDEX_STAT(
	i_DSCORE				IN		NUMBER,
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_Cursor_TRUNCATE		NUMBER;
	v_Truncate_String	VARCHAR2(100);
	TYPE T_C IS REF CURSOR;
	v_CURSOR T_C;
	v_SGID NUMBER;
	v_SGIDX NUMBER;
	v_UCID NUMBER;
	v_GOOD NUMBER(8,3);
	v_BAD NUMBER(8,3);
  BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR_TRUNCATE	:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE ALKINDEX_STAT';
	dbms_sql.parse(v_CURSOR_TRUNCATE, v_Truncate_String, DBMS_SQL.V7);
	DBMS_SQL.CLOSE_CURSOR(V_CURSOR_TRUNCATE);	

	INSERT INTO ALKINDEX_STAT (PRODUCT_CLUSTER_ID, USER_CLUSTER_ID, USER_CLUSTER_SUBGROUP_INDEX, TOT_USER_IN_SG)
	SELECT PRODUCT_CLUSTER_ID, USER_CLUSTER_ID, USER_CLUSTER_SUBGROUP_INDEX, COUNT(USER_ID)
	  FROM REL_USER_CLUSTER
    GROUP BY PRODUCT_CLUSTER_ID, USER_CLUSTER_ID, USER_CLUSTER_SUBGROUP_INDEX;

	OPEN v_CURSOR FOR
	 SELECT DISTINCT USER_CLUSTER_ID
	      , USER_CLUSTER_SUBGROUP_INDEX
	   FROM REL_USER_CLUSTER;
	LOOP
		FETCH v_CURSOR INTO v_UCID, v_SGIDX;
		EXIT WHEN v_CURSOR%NOTFOUND;

	SELECT SUM(DECODE(E.EVALUATION_SCALE_ID,3,1,4,1,5,1,6,1,0))
	     , SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,1,0))
	  INTO v_GOOD
	     , v_BAD
	  FROM EVALUATION E
	     , REL_USER_CLUSTER R
	 WHERE E.USER_ID = R.USER_ID
	   AND R.USER_CLUSTER_SUBGROUP_INDEX = v_SGIDX
	   AND E.EVALUATION_SCALE_ID >=1
	   AND E.PRODUCT_ID IN
     (SELECT PRODUCT_ID
	  FROM
     (SELECT PRODUCT_ID
        FROM PROD_UC_STAT
	 WHERE USER_CLUSTER_ID =v_UCID
  ORDER BY SCORE1 DESC
		 )
       WHERE ROWNUM < i_DSCORE);
--ORDERBYROWNUM

	UPDATE ALKINDEX_STAT
	   SET BI = NVL((v_BAD / (v_GOOD + v_BAD)),0)
	 WHERE USER_CLUSTER_ID = v_UCID
	   AND USER_CLUSTER_SUBGROUP_INDEX = v_SGIDX;

	END LOOP;

	CLOSE v_CURSOR;

	UPDATE ALKINDEX_STAT S
	   SET (NI, BBI)  = (SELECT WGT_TOT_PROD_IN_PC, FRN_BAD_REC
	  FROM PC_STAT PCS
	 WHERE S.PRODUCT_CLUSTER_ID = PCS.PRODUCT_CLUSTER_ID);

  END sp_INS_ReCalc_ALKINDEX_STAT;
	


END pkg_ALKINDI_STAT;
/

SHOW ERRORS
